﻿using log4net;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Moq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Controllers;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using Xunit;

namespace VA.PPMS.IWS.Api.Unit.Test
{
    public class PingControllerTests
    {
        [Fact]
        public void PingTestReturns200()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.GetAsync(It.IsAny<string>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.OK) {Content = new StringContent("Ping!")}));

            var controller = new PingController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };
            
            // Act
            var results = controller.Get();
            var statusCodeResult = results.GetAwaiter().GetResult() as ObjectResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(200, statusCodeResult.StatusCode);
            Assert.Equal("Ping!", statusCodeResult.Value);
        }

        [Fact]
        public void PingTestReturns500()
        {
            // Arrange
            var mockLogger = new Mock<ILog>();
            mockLogger.Setup(x => x.Info(It.IsAny<object>()));
            mockLogger.Setup(x => x.Error(It.IsAny<object>()));

            var mockConfiguration = new Mock<IIwsConfiguration>();

            var mockClient = new Mock<IHttpClientHandler>();
            mockClient.Setup(x => x.GetAsync(It.IsAny<string>())).Returns(Task.FromResult(new HttpResponseMessage(HttpStatusCode.InternalServerError)));

            var controller = new PingController(mockLogger.Object, mockConfiguration.Object, mockClient.Object) { ControllerContext = UnitTestHelper.CreateControllerContext() };

            // Act
            var results = controller.Get();
            var statusCodeResult = results.GetAwaiter().GetResult() as StatusCodeResult;

            // Assert
            Assert.NotNull(statusCodeResult);
            Assert.Equal(500, statusCodeResult.StatusCode);
        }
    }
}